//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Variadic Parameters
//:
//: Variadic parameters are variable input parameters that vary in the number of items they contain.
//:
//: Execute the code below.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func condense(values: String...) -> String {
    var result: String = " "
    for value in values {
        result += ", " + value
    }
    return result
}
let condensedString: String = condense(values: "argument 1", "argument 2", "argument 3", "argument 4", "argument 5", "argument 6")
print(condensedString)


//:
//: -------------------
//:
//: ## Task:
//:
//: Declare a new function that accepts a variadic parameter of type `Int`.
//:
//: The input represents a list of exam scores.
//:
//: Sum the whole value of each score and return the result, which will be the average of all exam scores.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here













